import { Download, Loader2 } from 'lucide-react';

interface ImageComparisonProps {
  originalImage: string;
  processedImage: string | null;
  isProcessing: boolean;
  onDownload: () => void;
}

export default function ImageComparison({
  originalImage,
  processedImage,
  isProcessing,
  onDownload
}: ImageComparisonProps) {
  return (
    <div className="space-y-6">
      <div className="grid md:grid-cols-2 gap-6">
        <div className="space-y-3">
          <h3 className="text-lg font-semibold text-gray-700">Original Image</h3>
          <div className="relative aspect-square bg-gray-100 rounded-lg overflow-hidden border-2 border-gray-200">
            <img
              src={originalImage}
              alt="Original"
              className="w-full h-full object-contain"
            />
          </div>
        </div>

        <div className="space-y-3">
          <h3 className="text-lg font-semibold text-gray-700">Processed Image</h3>
          <div className="relative aspect-square bg-gradient-to-br from-gray-100 to-gray-200 rounded-lg overflow-hidden border-2 border-gray-200">
            {isProcessing ? (
              <div className="absolute inset-0 flex flex-col items-center justify-center">
                <Loader2 className="w-12 h-12 text-blue-600 animate-spin mb-3" />
                <p className="text-gray-600 font-medium">Removing background...</p>
                <p className="text-sm text-gray-500 mt-1">This may take a few seconds</p>
              </div>
            ) : processedImage ? (
              <div className="relative w-full h-full">
                <div className="absolute inset-0 bg-[linear-gradient(45deg,#f0f0f0_25%,transparent_25%,transparent_75%,#f0f0f0_75%,#f0f0f0),linear-gradient(45deg,#f0f0f0_25%,transparent_25%,transparent_75%,#f0f0f0_75%,#f0f0f0)] bg-[length:20px_20px] bg-[position:0_0,10px_10px]" />
                <img
                  src={processedImage}
                  alt="Processed"
                  className="relative w-full h-full object-contain"
                />
              </div>
            ) : (
              <div className="absolute inset-0 flex items-center justify-center text-gray-400">
                <p>Processing will appear here</p>
              </div>
            )}
          </div>
        </div>
      </div>

      {processedImage && !isProcessing && (
        <div className="flex justify-center">
          <button
            onClick={onDownload}
            className="flex items-center space-x-2 px-6 py-3 bg-blue-600 hover:bg-blue-700 text-white font-semibold rounded-lg transition-colors shadow-lg hover:shadow-xl"
          >
            <Download className="w-5 h-5" />
            <span>Download Processed Image</span>
          </button>
        </div>
      )}
    </div>
  );
}
